/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class JarSignature {
    public static final String BLOB_SIGNATURE = "META-INF/SIGNATURE.BSF";
    private final Signature sig;
    private final X509Certificate[] certChain;
    private final CodeSigner[] codeSigners;
    private final SignerInfo[] signerInfos;

    public static JarSignature load(byte[] byArray) throws ParsingException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PKCS7 pKCS7 = new PKCS7(byArray);
        pKCS7.verify(new byte[0]);
        SignerInfo[] signerInfoArray = pKCS7.getSignerInfos();
        if (signerInfoArray == null || signerInfoArray.length != 1) {
            throw new IllegalArgumentException("BLOB signature currently only support single signer.");
        }
        X509Certificate x509Certificate = signerInfoArray[0].getCertificate(pKCS7);
        PublicKey publicKey = x509Certificate.getPublicKey();
        CodeSigner[] codeSignerArray = JarSignature.extractCodeSigners(signerInfoArray, pKCS7);
        Signature signature = JarSignature.getSignature(signerInfoArray[0]);
        signature.initVerify(publicKey);
        return new JarSignature(signature, signerInfoArray, codeSignerArray);
    }

    public static JarSignature create(PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = JarSignature.getSignature(privateKey.getAlgorithm());
        signature.initSign(privateKey);
        return new JarSignature(signature, x509CertificateArray);
    }

    private JarSignature(Signature signature, X509Certificate[] x509CertificateArray) {
        this.certChain = x509CertificateArray;
        this.signerInfos = null;
        this.codeSigners = null;
        this.sig = signature;
    }

    private JarSignature(Signature signature, SignerInfo[] signerInfoArray, CodeSigner[] codeSignerArray) {
        this.certChain = null;
        this.signerInfos = signerInfoArray;
        this.codeSigners = codeSignerArray;
        this.sig = signature;
    }

    public boolean isValidationMode() {
        return this.certChain == null;
    }

    private static Signature getSignature(String string) throws NoSuchAlgorithmException {
        if (string.equalsIgnoreCase("DSA")) {
            return Signature.getInstance("SHA1withDSA");
        }
        if (string.equalsIgnoreCase("RSA")) {
            return Signature.getInstance("SHA256withRSA");
        }
        if (string.equalsIgnoreCase("EC")) {
            return Signature.getInstance("SHA256withECDSA");
        }
        throw new IllegalArgumentException("Key algorithm should be either DSA, RSA or EC");
    }

    private static Signature getSignature(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        String string = signerInfo.getDigestAlgorithmId().getName();
        String string2 = signerInfo.getDigestEncryptionAlgorithmId().getName();
        String string3 = JarSignature.makeSigAlg(string, string2);
        return Signature.getInstance(string3);
    }

    String getSignatureAlgorithm() throws NoSuchAlgorithmException {
        return this.sig.getAlgorithm();
    }

    AlgorithmId getDigestAlgorithm() throws NoSuchAlgorithmException {
        String string = JarSignature.getDigAlgFromSigAlg(this.sig.getAlgorithm());
        return string != null ? AlgorithmId.get(string) : null;
    }

    AlgorithmId getKeyAlgorithm() throws NoSuchAlgorithmException {
        String string = JarSignature.getEncAlgFromSigAlg(this.sig.getAlgorithm());
        return string != null ? AlgorithmId.get(string) : null;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, SignatureException, IOException {
        if (this.isValidationMode()) {
            throw new UnsupportedOperationException("Method is not for validation mode.");
        }
        AlgorithmId algorithmId = this.getDigestAlgorithm();
        AlgorithmId[] algorithmIdArray = new AlgorithmId[]{algorithmId};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        Principal principal = this.certChain[0].getIssuerDN();
        BigInteger bigInteger = this.certChain[0].getSerialNumber();
        byte[] byArray = this.sig.sign();
        SignerInfo signerInfo = new SignerInfo((X500Name)principal, bigInteger, algorithmId, this.getKeyAlgorithm(), byArray);
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        PKCS7 pKCS7 = new PKCS7(algorithmIdArray, contentInfo, this.certChain, signerInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        pKCS7.encodeSignedData(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public InputStream updateWithZipEntry(String string, InputStream inputStream) throws SignatureException {
        try {
            this.sig.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SignatureException(unsupportedEncodingException);
        }
        return new ValidationStream(inputStream);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.sig.update(byArray);
    }

    public boolean isValid() {
        try {
            return this.sig.verify(this.signerInfos[0].getEncryptedDigest());
        }
        catch (Exception exception) {
            if (Config.getDeployDebug() || Config.getPluginDebug()) {
                Trace.ignored(exception);
            }
            return false;
        }
    }

    public CodeSigner[] getCodeSigners() {
        return this.codeSigners;
    }

    private static CodeSigner[] extractCodeSigners(SignerInfo[] signerInfoArray, PKCS7 pKCS7) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        for (int i = 0; i < signerInfoArray.length; ++i) {
            SignerInfo signerInfo = signerInfoArray[i];
            ArrayList<X509Certificate> arrayList2 = signerInfo.getCertificateChain(pKCS7);
            CertPath certPath = certificateFactory.generateCertPath(arrayList2);
            CodeSigner codeSigner = new CodeSigner(certPath, JarSignature.getTimestamp(signerInfo, certificateFactory));
            arrayList.add(codeSigner);
        }
        return arrayList.toArray(new CodeSigner[arrayList.size()]);
    }

    private static Timestamp getTimestamp(SignerInfo signerInfo, CertificateFactory certificateFactory) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute pKCS9Attribute;
        Timestamp timestamp = null;
        PKCS9Attributes pKCS9Attributes = signerInfo.getUnauthenticatedAttributes();
        if (pKCS9Attributes != null && (pKCS9Attribute = pKCS9Attributes.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 pKCS7 = new PKCS7((byte[])pKCS9Attribute.getValue());
            byte[] byArray = pKCS7.getContentInfo().getData();
            SignerInfo[] signerInfoArray = pKCS7.verify(byArray);
            ArrayList<X509Certificate> arrayList = signerInfoArray[0].getCertificateChain(pKCS7);
            CertPath certPath = certificateFactory.generateCertPath(arrayList);
            TimestampToken timestampToken = new TimestampToken(byArray);
            timestamp = new Timestamp(timestampToken.getDate(), certPath);
        }
        return timestamp;
    }

    private static String makeSigAlg(String string, String string2) {
        if ((string = string.replace("-", "").toUpperCase(Locale.ENGLISH)).equalsIgnoreCase("SHA")) {
            string = "SHA1";
        }
        if ((string2 = string2.toUpperCase(Locale.ENGLISH)).equals("EC")) {
            string2 = "ECDSA";
        }
        return string + "with" + string2;
    }

    private static String getDigAlgFromSigAlg(String string) {
        int n = (string = string.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private static String getEncAlgFromSigAlg(String string) {
        int n;
        string = string.toUpperCase(Locale.ENGLISH);
        int n2 = string.indexOf("WITH");
        String string2 = null;
        if (n2 > 0 && (string2 = (n = string.indexOf("AND", n2 + 4)) > 0 ? string.substring(n2 + 4, n) : string.substring(n2 + 4)).equalsIgnoreCase("ECDSA")) {
            string2 = "EC";
        }
        return string2;
    }

    private class ValidationStream
    extends InputStream {
        InputStream dataStream = null;

        public ValidationStream(InputStream inputStream) {
            this.dataStream = inputStream;
        }

        public int read() throws IOException {
            int n;
            block3: {
                n = this.dataStream.read();
                if (n > -1) {
                    try {
                        JarSignature.this.sig.update((byte)n);
                    }
                    catch (SignatureException signatureException) {
                        if (!Config.getDeployDebug() && !Config.getPluginDebug()) break block3;
                        Trace.ignored(signatureException);
                    }
                }
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            block3: {
                if ((n2 = this.dataStream.read(byArray, n, n2)) > 0) {
                    try {
                        JarSignature.this.sig.update(byArray, n, n2);
                    }
                    catch (SignatureException signatureException) {
                        if (!Config.getDeployDebug() && !Config.getPluginDebug()) break block3;
                        Trace.ignored(signatureException);
                    }
                }
            }
            return n2;
        }

        public void close() throws IOException {
            this.dataStream.close();
        }
    }
}

